/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jdbc.trace;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.apache.skywalking.apm.plugin.jdbc.trace.ConnectionInfo;
import org.apache.skywalking.apm.plugin.jdbc.trace.StatementTracing;

public class SWStatement
implements Statement {
    private Connection realConnection;
    private Statement realStatement;
    private ConnectionInfo connectInfo;

    public SWStatement(Connection realConnection, Statement realStatement, ConnectionInfo connectInfo) {
        this.realConnection = realConnection;
        this.realStatement = realStatement;
        this.connectInfo = connectInfo;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.realStatement.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.realStatement.isWrapperFor(iface);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return StatementTracing.execute(this.realStatement, this.connectInfo, "executeQuery", sql, new StatementTracing.Executable<ResultSet>(){

            @Override
            public ResultSet exe(Statement realStatement, String sql) throws SQLException {
                return realStatement.executeQuery(sql);
            }
        });
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return StatementTracing.execute(this.realStatement, this.connectInfo, "executeUpdate", sql, new StatementTracing.Executable<Integer>(){

            @Override
            public Integer exe(Statement realStatement, String sql) throws SQLException {
                return realStatement.executeUpdate(sql);
            }
        });
    }

    @Override
    public void close() throws SQLException {
        this.realStatement.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.realStatement.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.realStatement.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.realStatement.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.realStatement.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.realStatement.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.realStatement.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.realStatement.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.realStatement.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.realStatement.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.realStatement.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.realStatement.setCursorName(name);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return StatementTracing.execute(this.realStatement, this.connectInfo, "execute", sql, new StatementTracing.Executable<Boolean>(){

            @Override
            public Boolean exe(Statement realStatement, String sql) throws SQLException {
                return realStatement.execute(sql);
            }
        });
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.realStatement.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.realStatement.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.realStatement.getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.realStatement.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.realStatement.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.realStatement.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.realStatement.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.realStatement.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.realStatement.getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.realStatement.addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.realStatement.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return StatementTracing.execute(this.realStatement, this.connectInfo, "executeBatch", "", new StatementTracing.Executable<int[]>(){

            @Override
            public int[] exe(Statement realStatement, String sql) throws SQLException {
                return realStatement.executeBatch();
            }
        });
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.realConnection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.realStatement.getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.realStatement.getGeneratedKeys();
    }

    @Override
    public int executeUpdate(String sql, final int autoGeneratedKeys) throws SQLException {
        return StatementTracing.execute(this.realStatement, this.connectInfo, "executeUpdate", sql, new StatementTracing.Executable<Integer>(){

            @Override
            public Integer exe(Statement realStatement, String sql) throws SQLException {
                return realStatement.executeUpdate(sql, autoGeneratedKeys);
            }
        });
    }

    @Override
    public int executeUpdate(String sql, final int[] columnIndexes) throws SQLException {
        return StatementTracing.execute(this.realStatement, this.connectInfo, "executeUpdate", sql, new StatementTracing.Executable<Integer>(){

            @Override
            public Integer exe(Statement realStatement, String sql) throws SQLException {
                return realStatement.executeUpdate(sql, columnIndexes);
            }
        });
    }

    @Override
    public int executeUpdate(String sql, final String[] columnNames) throws SQLException {
        return StatementTracing.execute(this.realStatement, this.connectInfo, "executeUpdate", sql, new StatementTracing.Executable<Integer>(){

            @Override
            public Integer exe(Statement realStatement, String sql) throws SQLException {
                return realStatement.executeUpdate(sql, columnNames);
            }
        });
    }

    @Override
    public boolean execute(String sql, final int autoGeneratedKeys) throws SQLException {
        return StatementTracing.execute(this.realStatement, this.connectInfo, "execute", sql, new StatementTracing.Executable<Boolean>(){

            @Override
            public Boolean exe(Statement realStatement, String sql) throws SQLException {
                return realStatement.execute(sql, autoGeneratedKeys);
            }
        });
    }

    @Override
    public boolean execute(String sql, final int[] columnIndexes) throws SQLException {
        return StatementTracing.execute(this.realStatement, this.connectInfo, "execute", sql, new StatementTracing.Executable<Boolean>(){

            @Override
            public Boolean exe(Statement realStatement, String sql) throws SQLException {
                return realStatement.execute(sql, columnIndexes);
            }
        });
    }

    @Override
    public boolean execute(String sql, final String[] columnNames) throws SQLException {
        return StatementTracing.execute(this.realStatement, this.connectInfo, "execute", sql, new StatementTracing.Executable<Boolean>(){

            @Override
            public Boolean exe(Statement realStatement, String sql) throws SQLException {
                return realStatement.execute(sql, columnNames);
            }
        });
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.realStatement.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.realStatement.isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.realStatement.setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.realStatement.isPoolable();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.realStatement.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.realStatement.isCloseOnCompletion();
    }
}

