/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.rocketMQ.v3;

import com.alibaba.rocketmq.common.message.Message;
import com.alibaba.rocketmq.common.protocol.header.SendMessageRequestHeader;
import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.AbstractTag;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.rocketMQ.v3.define.SendCallBackEnhanceInfo;
import org.apache.skywalking.apm.util.StringUtil;

public class MessageSendInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final String ASYNC_SEND_OPERATION_NAME_PREFIX = "RocketMQ/";
    private static final AbstractTag<String> MQ_MESSAGE_KEYS_TAG = Tags.ofKey((String)"mq.message.keys");
    private static final AbstractTag<String> MQ_MESSAGE_TAGS_TAG = Tags.ofKey((String)"mq.message.tags");

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        String tags;
        Message message = (Message)allArguments[2];
        ContextCarrier contextCarrier = new ContextCarrier();
        String namingServiceAddress = String.valueOf(objInst.getSkyWalkingDynamicField());
        AbstractSpan span = ContextManager.createExitSpan((String)this.buildOperationName(message.getTopic()), (ContextCarrier)contextCarrier, (String)namingServiceAddress);
        span.setComponent((Component)ComponentsDefine.ROCKET_MQ_PRODUCER);
        Tags.MQ_BROKER.set(span, (String)allArguments[0]);
        Tags.MQ_TOPIC.set(span, message.getTopic());
        String keys = message.getKeys();
        if (StringUtil.isNotBlank((String)keys)) {
            span.tag(MQ_MESSAGE_KEYS_TAG, keys);
        }
        if (StringUtil.isNotBlank((String)(tags = message.getTags()))) {
            span.tag(MQ_MESSAGE_TAGS_TAG, tags);
        }
        contextCarrier.extensionInjector().injectSendingTimestamp();
        SpanLayer.asMQ((AbstractSpan)span);
        SendMessageRequestHeader requestHeader = (SendMessageRequestHeader)allArguments[3];
        StringBuilder properties = new StringBuilder(requestHeader.getProperties());
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            if (StringUtil.isEmpty((String)(next = next.next()).getHeadValue())) continue;
            properties.append(next.getHeadKey());
            properties.append('\u0001');
            properties.append(next.getHeadValue());
            properties.append('\u0002');
        }
        requestHeader.setProperties(properties.toString());
        if (allArguments[6] != null) {
            ((EnhancedInstance)allArguments[6]).setSkyWalkingDynamicField((Object)new SendCallBackEnhanceInfo(message.getTopic(), ContextManager.capture()));
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }

    private String buildOperationName(String topicName) {
        return ASYNC_SEND_OPERATION_NAME_PREFIX + topicName + "/Producer";
    }
}

