/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.kafka;

import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.kafka.CallbackCache;

public class CallbackAdapterInterceptor
implements Callback,
EnhancedInstance {
    private CallbackCache callbackCache;

    public CallbackAdapterInterceptor(CallbackCache callbackCache) {
        this.callbackCache = callbackCache;
    }

    public void onCompletion(RecordMetadata metadata, Exception exception) {
        ContextSnapshot snapshot = this.callbackCache.getSnapshot();
        AbstractSpan activeSpan = ContextManager.createLocalSpan((String)"Kafka/Producer/Callback");
        SpanLayer.asMQ((AbstractSpan)activeSpan);
        activeSpan.setComponent((Component)ComponentsDefine.KAFKA_PRODUCER);
        if (metadata != null) {
            Tags.MQ_TOPIC.set(activeSpan, metadata.topic());
        }
        ContextManager.continued((ContextSnapshot)snapshot);
        try {
            this.callbackCache.getCallback().onCompletion(metadata, exception);
        }
        catch (Throwable t) {
            ContextManager.activeSpan().log(t);
            throw t;
        }
        finally {
            if (exception != null) {
                ContextManager.activeSpan().log((Throwable)exception);
            }
            ContextManager.stopSpan();
        }
    }

    public Object getSkyWalkingDynamicField() {
        return this.callbackCache;
    }

    public void setSkyWalkingDynamicField(Object value) {
    }
}

