/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.mongodb.v3.support;

import com.mongodb.bulk.DeleteRequest;
import com.mongodb.bulk.InsertRequest;
import com.mongodb.bulk.UpdateRequest;
import com.mongodb.bulk.WriteRequest;
import com.mongodb.operation.CountOperation;
import com.mongodb.operation.CreateCollectionOperation;
import com.mongodb.operation.CreateIndexesOperation;
import com.mongodb.operation.CreateViewOperation;
import com.mongodb.operation.DeleteOperation;
import com.mongodb.operation.DistinctOperation;
import com.mongodb.operation.FindAndDeleteOperation;
import com.mongodb.operation.FindAndReplaceOperation;
import com.mongodb.operation.FindAndUpdateOperation;
import com.mongodb.operation.FindOperation;
import com.mongodb.operation.GroupOperation;
import com.mongodb.operation.InsertOperation;
import com.mongodb.operation.ListCollectionsOperation;
import com.mongodb.operation.MapReduceToCollectionOperation;
import com.mongodb.operation.MapReduceWithInlineResultsOperation;
import com.mongodb.operation.MixedBulkWriteOperation;
import com.mongodb.operation.UpdateOperation;
import java.util.List;
import org.apache.skywalking.apm.plugin.mongodb.v3.MongoPluginConfig;
import org.bson.BsonDocument;

public class MongoOperationHelper {
    private MongoOperationHelper() {
    }

    public static String getTraceParam(Object obj) {
        if (obj instanceof CountOperation) {
            BsonDocument filter = ((CountOperation)obj).getFilter();
            return MongoOperationHelper.limitFilter(filter.toString());
        }
        if (obj instanceof DistinctOperation) {
            BsonDocument filter = ((DistinctOperation)obj).getFilter();
            return MongoOperationHelper.limitFilter(filter.toString());
        }
        if (obj instanceof FindOperation) {
            BsonDocument filter = ((FindOperation)obj).getFilter();
            return MongoOperationHelper.limitFilter(filter.toString());
        }
        if (obj instanceof GroupOperation) {
            BsonDocument filter = ((GroupOperation)obj).getFilter();
            return MongoOperationHelper.limitFilter(filter.toString());
        }
        if (obj instanceof ListCollectionsOperation) {
            BsonDocument filter = ((ListCollectionsOperation)obj).getFilter();
            return MongoOperationHelper.limitFilter(filter.toString());
        }
        if (obj instanceof MapReduceWithInlineResultsOperation) {
            BsonDocument filter = ((MapReduceWithInlineResultsOperation)obj).getFilter();
            return MongoOperationHelper.limitFilter(filter.toString());
        }
        if (obj instanceof DeleteOperation) {
            List writeRequestList = ((DeleteOperation)obj).getDeleteRequests();
            return MongoOperationHelper.getFilter(writeRequestList);
        }
        if (obj instanceof InsertOperation) {
            List writeRequestList = ((InsertOperation)obj).getInsertRequests();
            return MongoOperationHelper.getFilter(writeRequestList);
        }
        if (obj instanceof UpdateOperation) {
            List writeRequestList = ((UpdateOperation)obj).getUpdateRequests();
            return MongoOperationHelper.getFilter(writeRequestList);
        }
        if (obj instanceof CreateCollectionOperation) {
            String filter = ((CreateCollectionOperation)obj).getCollectionName();
            return MongoOperationHelper.limitFilter(filter);
        }
        if (obj instanceof CreateIndexesOperation) {
            List filter = ((CreateIndexesOperation)obj).getIndexNames();
            return MongoOperationHelper.limitFilter(filter.toString());
        }
        if (obj instanceof CreateViewOperation) {
            String filter = ((CreateViewOperation)obj).getViewName();
            return MongoOperationHelper.limitFilter(filter);
        }
        if (obj instanceof FindAndDeleteOperation) {
            BsonDocument filter = ((FindAndDeleteOperation)obj).getFilter();
            return MongoOperationHelper.limitFilter(filter.toString());
        }
        if (obj instanceof FindAndReplaceOperation) {
            BsonDocument filter = ((FindAndReplaceOperation)obj).getFilter();
            return MongoOperationHelper.limitFilter(filter.toString());
        }
        if (obj instanceof FindAndUpdateOperation) {
            BsonDocument filter = ((FindAndUpdateOperation)obj).getFilter();
            return MongoOperationHelper.limitFilter(filter.toString());
        }
        if (obj instanceof MapReduceToCollectionOperation) {
            BsonDocument filter = ((MapReduceToCollectionOperation)obj).getFilter();
            return MongoOperationHelper.limitFilter(filter.toString());
        }
        if (obj instanceof MixedBulkWriteOperation) {
            List writeRequestList = ((MixedBulkWriteOperation)obj).getWriteRequests();
            return MongoOperationHelper.getFilter(writeRequestList);
        }
        return "";
    }

    private static String getFilter(List<? extends WriteRequest> writeRequestList) {
        StringBuilder params = new StringBuilder();
        for (WriteRequest writeRequest : writeRequestList) {
            int filterLengthLimit;
            if (writeRequest instanceof InsertRequest) {
                params.append(((InsertRequest)writeRequest).getDocument().toString()).append(",");
            } else if (writeRequest instanceof DeleteRequest) {
                params.append(((DeleteRequest)writeRequest).getFilter()).append(",");
            } else if (writeRequest instanceof UpdateRequest) {
                params.append(((UpdateRequest)writeRequest).getFilter()).append(",");
            }
            if ((filterLengthLimit = MongoPluginConfig.Plugin.MongoDB.FILTER_LENGTH_LIMIT) <= 0 || params.length() <= filterLengthLimit) continue;
            return params.substring(0, filterLengthLimit) + "...";
        }
        return params.toString();
    }

    private static String limitFilter(String filter) {
        StringBuilder params = new StringBuilder();
        int filterLengthLimit = MongoPluginConfig.Plugin.MongoDB.FILTER_LENGTH_LIMIT;
        if (filterLengthLimit > 0 && filter.length() > filterLengthLimit) {
            return params.append(filter, 0, filterLengthLimit).append("...").toString();
        }
        return filter;
    }
}

