/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.mybatis;

import java.lang.reflect.Method;
import java.util.Objects;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.v2.InstanceMethodsAroundInterceptorV2;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.v2.MethodInvocationContext;
import org.apache.skywalking.apm.agent.core.util.MethodUtil;
import org.apache.skywalking.apm.plugin.mybatis.Constants;

public class MyBatisShellMethodInterceptor
implements InstanceMethodsAroundInterceptorV2 {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInvocationContext context) throws Throwable {
        if (ContextManager.getRuntimeContext().get((Object)"mybatis_shell_method_name") == null) {
            context.setContext(Constants.COLLECTED_FLAG);
            String operationName = MethodUtil.generateOperationName((Method)method);
            ContextManager.getRuntimeContext().put((Object)"mybatis_shell_method_name", (Object)operationName);
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret, MethodInvocationContext context) throws Throwable {
        if (Objects.nonNull(context.getContext())) {
            ContextManager.getRuntimeContext().remove((Object)"mybatis_shell_method_name");
        }
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t, MethodInvocationContext context) {
        if (Objects.nonNull(context.getContext())) {
            ContextManager.getRuntimeContext().remove((Object)"mybatis_shell_method_name");
        }
    }
}

