/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jackson;

import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.jackson.comm.Constants;

public class WriteValueAsStringInterceptor
implements InstanceMethodsAroundInterceptor {
    public static final String OPERATION_NAME_JACKSON = "Jackson/";

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        AbstractSpan span = ContextManager.createLocalSpan((String)(OPERATION_NAME_JACKSON + method.getDeclaringClass().getSimpleName() + "." + method.getName()));
        span.setComponent((Component)ComponentsDefine.JACKSON);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        if (!ContextManager.isActive()) {
            return ret;
        }
        if (ret instanceof String) {
            ContextManager.activeSpan().tag(Constants.SPAN_TAG_KEY_LENGTH, Integer.toString(((String)ret).length()));
        }
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }
}

