/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.thrift.client;

import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.AsyncSpan;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.thrift.commons.ReflectionUtils;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.async.TAsyncMethodCall;

public class TAsyncMethodCallInterceptor
implements InstanceConstructorInterceptor,
InstanceMethodsAroundInterceptor {
    private String remotePeer = "UNKNOWN";

    public void onConstruct(final EnhancedInstance objInst, final Object[] allArguments) throws NoSuchFieldException, IllegalAccessException {
        ReflectionUtils.setValue(TAsyncMethodCall.class, objInst, "callback", new AsyncMethodCallback<Object>(){
            final AsyncMethodCallback<Object> callback;
            {
                this.callback = (AsyncMethodCallback)allArguments[3];
            }

            public void onComplete(Object response) {
                try {
                    AsyncSpan span = (AsyncSpan)objInst.getSkyWalkingDynamicField();
                    span.asyncFinish();
                }
                finally {
                    this.callback.onComplete(response);
                }
            }

            public void onError(Exception exception) {
                try {
                    AsyncSpan span = (AsyncSpan)objInst.getSkyWalkingDynamicField();
                    span.asyncFinish().log((Throwable)exception);
                }
                finally {
                    this.callback.onError(exception);
                }
            }
        });
        if (allArguments[2] instanceof EnhancedInstance) {
            this.remotePeer = (String)((EnhancedInstance)allArguments[2]).getSkyWalkingDynamicField();
        }
    }

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        AbstractSpan span = ContextManager.createExitSpan((String)objInst.getClass().getName(), (String)this.remotePeer);
        span.setComponent((Component)ComponentsDefine.THRIFT_CLIENT);
        SpanLayer.asRPCFramework((AbstractSpan)span);
        AbstractSpan async = span.prepareForAsync();
        objInst.setSkyWalkingDynamicField((Object)async);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().errorOccurred().log(t);
    }
}

