/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.fastjson;

import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.StaticMethodsAroundInterceptor;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.fastjson.common.Constants;

public class ToJsonBytesInterceptor
implements StaticMethodsAroundInterceptor {
    public static final String OPERATION_NAME_TO_JSON = "Fastjson/";

    public void beforeMethod(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, MethodInterceptResult result) {
        AbstractSpan span = ContextManager.createLocalSpan((String)(OPERATION_NAME_TO_JSON + method.getName()));
        span.setComponent((Component)ComponentsDefine.FASTJSON);
    }

    public Object afterMethod(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, Object ret) {
        if (!ContextManager.isActive()) {
            return ret;
        }
        if (ret instanceof byte[]) {
            ContextManager.activeSpan().tag(Constants.SPAN_TAG_KEY_LENGTH, Integer.toString(((byte[])ret).length));
        }
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }
}

