/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.netty.http.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.netty.http.common.AttributeKeys;
import org.apache.skywalking.apm.plugin.netty.http.config.NettyHttpPluginConfig;
import org.apache.skywalking.apm.plugin.netty.http.utils.HttpDataCollectUtils;
import org.apache.skywalking.apm.plugin.netty.http.utils.TypeUtils;

@ChannelHandler.Sharable
public class NettyHttpRequestDecoderTracingHandler
extends ChannelInboundHandlerAdapter {
    private static final ILog LOGGER = LogManager.getLogger(NettyHttpRequestDecoderTracingHandler.class);

    public static NettyHttpRequestDecoderTracingHandler getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private NettyHttpRequestDecoderTracingHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        try {
            if (TypeUtils.isFullHttpRequest(msg)) {
                FullHttpRequest request = (FullHttpRequest)msg;
                AbstractSpan span = this.createEntrySpan(ctx, (HttpRequest)request);
                if (NettyHttpPluginConfig.Plugin.NettyHttp.COLLECT_REQUEST_BODY) {
                    HttpDataCollectUtils.collectHttpRequestBody(request.headers(), request.content(), span);
                }
            } else if (TypeUtils.isHttpRequest(msg)) {
                this.createEntrySpan(ctx, (HttpRequest)msg);
                ctx.channel().attr(AttributeKeys.HTTP_REQUEST_HEADER).set((Object)((HttpRequest)msg).headers());
            } else if (TypeUtils.isLastHttpContent(msg)) {
                AbstractSpan span = (AbstractSpan)ctx.channel().attr(AttributeKeys.HTTP_SERVER_SPAN).get();
                HttpHeaders headers = (HttpHeaders)ctx.channel().attr(AttributeKeys.HTTP_REQUEST_HEADER).getAndSet(null);
                if (NettyHttpPluginConfig.Plugin.NettyHttp.COLLECT_REQUEST_BODY) {
                    HttpDataCollectUtils.collectHttpRequestBody(headers, ((LastHttpContent)msg).content(), span);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Fail to trace netty http request", (Throwable)e);
        }
        finally {
            try {
                ctx.fireChannelRead(msg);
            }
            catch (Throwable throwable) {
                AbstractSpan span = (AbstractSpan)ctx.channel().attr(AttributeKeys.HTTP_SERVER_SPAN).getAndSet(null);
                if (span != null) {
                    span.errorOccurred();
                    span.log(throwable);
                    Tags.HTTP_RESPONSE_STATUS_CODE.set(span, Integer.valueOf(500));
                    span.asyncFinish();
                }
                throw throwable;
            }
        }
    }

    private AbstractSpan createEntrySpan(ChannelHandlerContext ctx, HttpRequest request) {
        AbstractSpan lastSpan = (AbstractSpan)ctx.channel().attr(AttributeKeys.HTTP_SERVER_SPAN).getAndSet(null);
        if (null != lastSpan) {
            lastSpan.asyncFinish();
        }
        HttpHeaders headers = request.headers();
        ContextCarrier contextCarrier = new ContextCarrier();
        CarrierItem item = contextCarrier.items();
        while (item.hasNext()) {
            item = item.next();
            item.setHeadValue(headers.get(item.getHeadKey()));
        }
        InetSocketAddress address = (InetSocketAddress)ctx.channel().localAddress();
        String peer = address.getAddress().getHostAddress() + ":" + address.getPort();
        String url = peer + request.uri();
        String method = request.method().name();
        AbstractSpan span = ContextManager.createEntrySpan((String)("Netty-http:" + request.uri()), (ContextCarrier)contextCarrier);
        span.prepareForAsync();
        SpanLayer.asHttp((AbstractSpan)span);
        span.setComponent((Component)ComponentsDefine.NETTY_HTTP);
        Tags.HTTP.METHOD.set(span, method);
        boolean sslFlag = ctx.channel().pipeline().context(SslHandler.class) != null;
        Tags.URL.set(span, sslFlag ? "https://" + url : "http://" + url);
        ctx.channel().attr(AttributeKeys.HTTP_SERVER_SPAN).set((Object)span);
        ContextManager.stopSpan((AbstractSpan)span);
        return span;
    }

    private static class SingletonHolder {
        private static final NettyHttpRequestDecoderTracingHandler INSTANCE = new NettyHttpRequestDecoderTracingHandler();

        private SingletonHolder() {
        }
    }
}

