/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.rabbitmq;

import com.rabbitmq.client.AMQP;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class RabbitMQProducerInterceptor
implements InstanceMethodsAroundInterceptor {
    public static final String OPERATE_NAME_PREFIX = "RabbitMQ/";
    public static final String PRODUCER_OPERATE_NAME_SUFFIX = "/Producer";

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        AMQP.BasicProperties.Builder propertiesBuilder;
        ContextCarrier contextCarrier = new ContextCarrier();
        AMQP.BasicProperties properties = (AMQP.BasicProperties)allArguments[4];
        HashMap<String, String> headers = new HashMap<String, String>();
        if (properties != null) {
            propertiesBuilder = properties.builder().appId(properties.getAppId()).clusterId(properties.getClusterId()).contentEncoding(properties.getContentEncoding()).contentType(properties.getContentType()).correlationId(properties.getCorrelationId()).deliveryMode(properties.getDeliveryMode()).expiration(properties.getExpiration()).messageId(properties.getMessageId()).priority(properties.getPriority()).replyTo(properties.getReplyTo()).timestamp(properties.getTimestamp()).type(properties.getType()).userId(properties.getUserId());
            if (properties.getHeaders() != null) {
                headers.putAll(properties.getHeaders());
            }
        } else {
            propertiesBuilder = new AMQP.BasicProperties.Builder();
        }
        String exChangeName = (String)allArguments[0];
        String queueName = (String)allArguments[1];
        String url = (String)objInst.getSkyWalkingDynamicField();
        AbstractSpan activeSpan = ContextManager.createExitSpan((String)("RabbitMQ/Topic/" + exChangeName + "Queue/" + queueName + PRODUCER_OPERATE_NAME_SUFFIX), (ContextCarrier)contextCarrier, (String)url);
        Tags.MQ_BROKER.set(activeSpan, url);
        Tags.MQ_QUEUE.set(activeSpan, queueName);
        Tags.MQ_TOPIC.set(activeSpan, exChangeName);
        contextCarrier.extensionInjector().injectSendingTimestamp();
        SpanLayer.asMQ((AbstractSpan)activeSpan);
        activeSpan.setComponent((Component)ComponentsDefine.RABBITMQ_PRODUCER);
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            next = next.next();
            headers.put(next.getHeadKey(), next.getHeadValue());
        }
        allArguments[4] = propertiesBuilder.headers(headers).build();
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }
}

