/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.neo4j.v4x;

import java.lang.reflect.Method;
import java.util.concurrent.CompletionStage;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.neo4j.v4x.SessionRequiredInfo;

public class SessionAcquireConnectionInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        SessionRequiredInfo requiredInfo = (SessionRequiredInfo)objInst.getSkyWalkingDynamicField();
        if (requiredInfo == null) {
            return;
        }
        AbstractSpan span = ContextManager.createExitSpan((String)"Neo4j", (String)"Unset");
        Tags.DB_TYPE.set(span, "Neo4j");
        span.setComponent((Component)ComponentsDefine.NEO4J);
        SpanLayer.asDB((AbstractSpan)span);
        ContextManager.continued((ContextSnapshot)requiredInfo.getContextSnapshot());
        span.prepareForAsync();
        ContextManager.stopSpan();
        requiredInfo.setSpan(span);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        SessionRequiredInfo requiredInfo = (SessionRequiredInfo)objInst.getSkyWalkingDynamicField();
        if (requiredInfo == null) {
            return ret;
        }
        CompletionStage connectionStage = (CompletionStage)ret;
        return connectionStage.thenApply(connection -> {
            if (connection == null) {
                return null;
            }
            try {
                AbstractSpan span = requiredInfo.getSpan();
                span.setPeer(connection.serverAddress().toString());
                Tags.DB_INSTANCE.set(span, connection.databaseName().databaseName().orElse(""));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return connection;
        });
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }
}

